/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;
import org.das2.datum.DatumRange;

public class RowPngWalkView
extends PngWalkView {
    public static final int DEFAULT_CELL_SIZE = 100;
    public static final int MINIMUM_CELL_SIZE = 20;
    private int cellSize = 100;
    protected JScrollPane scrollPane;
    private Canvas canvas;
    private double restoreScrollPct = -1.0;

    public RowPngWalkView(WalkImageSequence sequence) {
        super(sequence);
        MouseWheelListener[] ll;
        this.setShowCaptions(true);
        this.setLayout(new BorderLayout());
        this.canvas = new Canvas();
        this.scrollPane = new JScrollPane(this.canvas, 20, 32);
        for (MouseWheelListener l : ll = this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(l);
        }
        this.scrollPane.addMouseWheelListener(this.getMouseWheelListener());
        this.canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (RowPngWalkView.this.seq == null) {
                    return;
                }
                int clickCell = (int)Math.floor((double)e.getX() / (double)RowPngWalkView.this.cellSize);
                RowPngWalkView.this.selectCell(clickCell);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int clickCell = (int)Math.floor((double)e.getX() / (double)RowPngWalkView.this.cellSize);
                    RowPngWalkView.this.selectCell(clickCell);
                    RowPngWalkView.this.getPopup().show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (e.isPopupTrigger()) {
                    RowPngWalkView.this.getPopup().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (RowPngWalkView.this.restoreScrollPct >= 0.0) {
                    JScrollBar sb = RowPngWalkView.this.scrollPane.getHorizontalScrollBar();
                    int newScroll = (int)(RowPngWalkView.this.restoreScrollPct * (double)(sb.getMaximum() - sb.getVisibleAmount()));
                    if (newScroll < 0) {
                        newScroll = 0;
                    }
                    sb.setValue(newScroll);
                    RowPngWalkView.this.restoreScrollPct = -1.0;
                }
            }
        });
        this.scrollPane.getHorizontalScrollBar().getModel().addChangeListener(new ChangeListener(){
            ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RowPngWalkView.this.seq == null) {
                    return;
                }
                if (!RowPngWalkView.this.canvas.isShowing()) {
                    return;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        Rectangle bounds = RowPngWalkView.this.scrollPane.getViewport().getViewRect();
                        int first = Math.max(0, (bounds.x - bounds.width) / RowPngWalkView.this.cellSize);
                        int last = Math.min(RowPngWalkView.this.seq.size(), (bounds.x + 2 * bounds.width) / RowPngWalkView.this.cellSize + 1);
                        for (int i = first; i < last; ++i) {
                            RowPngWalkView.this.seq.imageAt(i).getThumbnail(true);
                        }
                    }
                };
                this.ex.schedule(run, 200L, TimeUnit.MILLISECONDS);
            }
        });
        this.add(this.scrollPane);
    }

    @Override
    protected void sequenceChanged() {
        this.updateLayout();
        if (this.scrollPane != null) {
            this.scrollPane.getHorizontalScrollBar().setValue(0);
        }
    }

    @Override
    protected void thumbnailSizeChanged() {
        JScrollBar sb = this.scrollPane.getHorizontalScrollBar();
        this.restoreScrollPct = (double)sb.getValue() / (double)(sb.getMaximum() - sb.getVisibleAmount());
        this.cellSize = this.getThumbnailSize();
        this.updateLayout();
        super.thumbnailSizeChanged();
    }

    @Override
    public JComponent getMouseTarget() {
        return this.canvas;
    }

    private void updateLayout() {
        if (this.canvas == null) {
            return;
        }
        if (this.seq != null) {
            this.canvas.setPreferredSize(new Dimension(this.cellSize * this.seq.size(), this.cellSize));
        } else {
            this.canvas.setPreferredSize(new Dimension(0, 0));
        }
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    private void selectCell(int n) {
        this.seq.setIndex(n);
    }

    @Override
    int getNextInterval(int index) {
        int i = this.getVisibleRect().width / this.cellSize;
        return index + i;
    }

    @Override
    int getNextPage(int index) {
        int i = this.getVisibleRect().width / this.cellSize;
        return index + i * 4;
    }

    @Override
    int getPrevInterval(int index) {
        int i = this.getVisibleRect().width / this.cellSize;
        return index - i;
    }

    @Override
    int getPrevPage(int index) {
        int i = this.getVisibleRect().width / this.cellSize;
        return index - i * 4;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("index")) {
            int i = (Integer)e.getOldValue();
            int x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
            i = (Integer)e.getNewValue();
            x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
            int scrollMin = this.scrollPane.getHorizontalScrollBar().getValue();
            int scrollMax = scrollMin + this.scrollPane.getHorizontalScrollBar().getVisibleAmount();
            int pos = i * this.cellSize - this.getWidth() / 2 + this.cellSize / 2;
            if (scrollMin > i * this.cellSize || scrollMax < (i + 1) * this.cellSize) {
                this.scrollPane.getHorizontalScrollBar().setValue(pos);
            }
        } else if (e.getPropertyName().equals("thumbLoaded") || e.getPropertyName().equals("imageLoaded") || e.getPropertyName().equals("badgeChange")) {
            int i = (Integer)e.getNewValue();
            int x = i * this.cellSize;
            this.canvas.repaint(new Rectangle(x, 0, this.cellSize, this.cellSize));
        } else if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        }
    }

    private class Canvas
    extends JPanel
    implements Scrollable {
        private final Font smallFont = new Font("Dialog", 0, 6);
        private final Font normalFont = new Font("Dialog", 0, 12);
        Timer repaintTimer;

        public Canvas() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.repaintTimer = new Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Canvas.this.repaint();
                }
            });
            this.repaintTimer.setRepeats(false);
        }

        private void repaintSoon() {
            this.repaintTimer.restart();
        }

        @Override
        public void paintComponent(Graphics g1) {
            int i;
            super.paintComponent(g1);
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (RowPngWalkView.this.cellSize < 100) {
                g2.setFont(this.smallFont);
            } else {
                g2.setFont(this.normalFont);
            }
            Rectangle bounds = g2.getClipBounds();
            FontMetrics fm = g2.getFontMetrics();
            if (RowPngWalkView.this.seq == null) {
                return;
            }
            for (i = 0; i < RowPngWalkView.this.seq.size(); ++i) {
                RowPngWalkView.this.seq.imageAt(i).removeObserver(RowPngWalkView.this);
            }
            int imax = Math.min(RowPngWalkView.this.seq.size() - 1, (bounds.x + bounds.width) / RowPngWalkView.this.cellSize);
            List<DatumRange> drs = RowPngWalkView.this.seq.getActiveSubrange();
            for (i = bounds.x / RowPngWalkView.this.cellSize; i <= imax; ++i) {
                Shape oldClip;
                int cy;
                int cx;
                DatumRange prevDr;
                if (i == RowPngWalkView.this.seq.getIndex()) {
                    g2.setColor(Color.orange);
                    g2.fillRect(i * RowPngWalkView.this.cellSize, 0, RowPngWalkView.this.cellSize, RowPngWalkView.this.cellSize);
                }
                WalkImage wimage = RowPngWalkView.this.seq.imageAt(i);
                wimage.addObserver(RowPngWalkView.this);
                BufferedImage thumb = wimage.getThumbnail(!RowPngWalkView.this.scrollPane.getHorizontalScrollBar().getValueIsAdjusting());
                Dimension d = wimage.getThumbnailDimension(false);
                if (d != null && thumb != null) {
                    int h;
                    int w;
                    double s = Math.min((double)(RowPngWalkView.this.cellSize - 4) / (double)thumb.getWidth(), (double)(RowPngWalkView.this.cellSize - 4 - fm.getHeight()) / (double)thumb.getHeight());
                    if (s < 1.0 && (thumb = wimage.getThumbnail(w = (int)(s * (double)thumb.getWidth()), h = (int)(s * (double)thumb.getHeight()), true)) == PngWalkView.loadingImage) {
                        this.repaintSoon();
                    }
                } else {
                    thumb = wimage.getStatus() == WalkImage.Status.MISSING ? wimage.getImage() : PngWalkView.loadingImage;
                }
                int imgX = i * RowPngWalkView.this.cellSize + (RowPngWalkView.this.cellSize - thumb.getWidth()) / 2;
                int imgY = (RowPngWalkView.this.cellSize - thumb.getHeight() - fm.getHeight()) / 2;
                g2.drawImage((Image)thumb, imgX, imgY, null);
                if (PngWalkTool.isQualityControlEnabled() && RowPngWalkView.this.seq.getQualityControlSequence() != null) {
                    RowPngWalkView.this.paintQualityControlIcon(i, g2, imgX, imgY, true);
                }
                int ds = 6;
                DatumRange thisDr = RowPngWalkView.this.seq.imageAt(i).getDatumRange();
                DatumRange nextDr = i < RowPngWalkView.this.seq.size() - 1 ? RowPngWalkView.this.seq.imageAt(i + 1).getDatumRange() : null;
                DatumRange datumRange = prevDr = i > 0 ? RowPngWalkView.this.seq.imageAt(i - 1).getDatumRange() : null;
                if (drs != null && thisDr != null && nextDr != null && !nextDr.equals((Object)thisDr.next())) {
                    g2.setColor(Color.GRAY);
                    cx = i * RowPngWalkView.this.cellSize + RowPngWalkView.this.cellSize - ds;
                    cy = RowPngWalkView.this.cellSize - fm.getHeight() - 3;
                    oldClip = g2.getClip();
                    g2.fillPolygon(new int[]{cx, cx + ds, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                    g2.setClip(oldClip);
                }
                if (drs != null && thisDr != null && prevDr != null && !prevDr.equals((Object)thisDr.previous())) {
                    g2.setColor(Color.GRAY);
                    cx = i * RowPngWalkView.this.cellSize;
                    cy = RowPngWalkView.this.cellSize - fm.getHeight() - 3;
                    oldClip = g2.getClip();
                    g2.fillPolygon(new int[]{cx, cx, cx + ds, cx}, new int[]{cy, cy - ds, cy, cy}, 4);
                    g2.setClip(oldClip);
                }
                if (!RowPngWalkView.this.showCaptions || wimage.getCaption() == null) continue;
                cx = i * RowPngWalkView.this.cellSize + (RowPngWalkView.this.cellSize - thumb.getWidth()) / 2;
                cy = (RowPngWalkView.this.cellSize + thumb.getHeight() + fm.getHeight()) / 2;
                g2.setColor(Color.BLACK);
                oldClip = g2.getClip();
                g2.clip(new Rectangle(cx, 0, (RowPngWalkView.this.cellSize + thumb.getWidth()) / 2, this.getHeight()));
                String s = wimage.getCaption();
                if (s.startsWith("orbit:")) {
                    s = s.substring(6);
                }
                if (s.length() > 20 && RowPngWalkView.this.cellSize < 400) {
                    g2.setFont(this.smallFont);
                }
                g2.drawString(s, cx, cy);
                g2.setClip(oldClip);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
            return RowPngWalkView.this.cellSize;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
            int x = RowPngWalkView.this.scrollPane.getHorizontalScrollBar().getVisibleAmount() / RowPngWalkView.this.cellSize * RowPngWalkView.this.cellSize;
            return x;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

